/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: CcLinkIeSlaveIf_Public.h 75645 2018-05-03 07:52:42Z Sven $:
**************************************************************************************/

#ifndef _CCLIESIF_PUBLIC_H
#define _CCLIESIF_PUBLIC_H

#include <stdint.h>
#include <Hil_Packet.h>

#define CCLIES_IF_QUEUE_NAME "CCLIES_IF_QUE"

#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(CCLIESIF_PUBLIC_H)
#endif

#define CCLIES_IF_CMD_SET_CONFIG_REQ 0x0000A700
#define CCLIES_IF_CMD_SET_CONFIG_CNF 0x0000A701

/*-------------------------------------*/
#define CCLIES_IF_CMD_STATUS_IND 0x0000A720
#define CCLIES_IF_CMD_STATUS_RES 0x0000A721

#define CCLIES_IF_CMD_GET_STATUS_REQ 0x0000A722
#define CCLIES_IF_CMD_GET_STATUS_CNF 0x0000A723

#define CCLIES_IF_CMD_SET_DET_NODE_STATUS_REQ 0x0000A724
#define CCLIES_IF_CMD_SET_DET_NODE_STATUS_CNF 0x0000A725

/*-------------------------------------*/
#define CCLIES_IF_CMD_REGISTER_TRANSIENT1_REQ 0x0000A740
#define CCLIES_IF_CMD_REGISTER_TRANSIENT1_CNF 0x0000A741

#define CCLIES_IF_CMD_UNREGISTER_TRANSIENT1_REQ 0x0000A742
#define CCLIES_IF_CMD_UNREGISTER_TRANSIENT1_CNF 0x0000A743

#define CCLIES_IF_CMD_SEND_TRANSIENT1_REQ 0x0000A744
#define CCLIES_IF_CMD_SEND_TRANSIENT1_CNF 0x0000A745

#define CCLIES_IF_CMD_RECV_TRANSIENT1_IND 0x0000A746
#define CCLIES_IF_CMD_RECV_TRANSIENT1_RES 0x0000A747

/*-------------------------------------*/
#define CCLIES_IF_CMD_REGISTER_TRANSIENT2_REQ 0x0000A750
#define CCLIES_IF_CMD_REGISTER_TRANSIENT2_CNF 0x0000A751

#define CCLIES_IF_CMD_UNREGISTER_TRANSIENT2_REQ 0x0000A752
#define CCLIES_IF_CMD_UNREGISTER_TRANSIENT2_CNF 0x0000A753

#define CCLIES_IF_CMD_SEND_TRANSIENT2_REQ 0x0000A754
#define CCLIES_IF_CMD_SEND_TRANSIENT2_CNF 0x0000A755

#define CCLIES_IF_CMD_RECV_TRANSIENT2_IND 0x0000A756
#define CCLIES_IF_CMD_RECV_TRANSIENT2_RES 0x0000A757

/*-------------------------------------*/
#define CCLIES_IF_CMD_REGISTER_SLMP_REQ 0x0000A760
#define CCLIES_IF_CMD_REGISTER_SLMP_CNF 0x0000A761

#define CCLIES_IF_CMD_UNREGISTER_SLMP_REQ 0x0000A762
#define CCLIES_IF_CMD_UNREGISTER_SLMP_CNF 0x0000A763

#define CCLIES_IF_CMD_SEND_SLMP_REQ 0x0000A764
#define CCLIES_IF_CMD_SEND_SLMP_CNF 0x0000A765

#define CCLIES_IF_CMD_RECV_SLMP_IND 0x0000A766
#define CCLIES_IF_CMD_RECV_SLMP_RES 0x0000A767

#define CCLIES_IF_CMD_GET_COUNTERS_REQ 0x0000A7E0
#define CCLIES_IF_CMD_GET_COUNTERS_CNF 0x0000A7E1

/******************************************************************************
 * Packet: CCLIES_IF_CMD_SET_CONFIG_REQ/CCLIES_IF_CMD_SET_CONFIG_CNF
 */

#define CCLIES_IF_SET_CONFIG_DEVICE_TYPE_INTELLIGENT_DEVICE 0x33
#define CCLIES_IF_SET_CONFIG_DEVICE_TYPE_REMOTE_DEVICE 0x34

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_CONFIG_REQ_DATA_Ttag
{
  uint32_t ulSystemFlags;
  uint32_t ulWatchdogTime;

  uint8_t bNetworkNumber;
  uint8_t bStationNumber;

  uint8_t bDeviceType;

  uint8_t bIOType;

  uint16_t usMaxRWwPoints;
  uint16_t usMaxRYBytes;

  uint16_t usMaxRWrPoints;
  uint16_t usMaxRXBytes;

  uint16_t usMinRWwPoints;
  uint16_t usMinRYBytes;

  uint16_t usMinRWrPoints;
  uint16_t usMinRXBytes;

  uint32_t ulConfigFlags;

  uint8_t bNetVersion;
  uint16_t usNetModelType;
  uint32_t ulNetUnitModelCode;
  uint16_t usNetVendorCode;

  uint8_t abNetUnitModelName[20];
  uint8_t abNetVendorName[32];

  uint16_t usHwVersion;
  uint16_t usDeviceVersion;

  uint8_t bInformationFlag;
  uint8_t bCtrlVersion;
  uint16_t usCtrlModelType;
  uint32_t ulCtrlUnitModelCode;
  uint16_t usCtrlVendorCode;
  uint8_t abCtrlUnitModelName[20];
  uint8_t abCtrlVendorName[32];
  uint32_t ulVendorInformation;

  uint16_t usUnitVersion;

  uint8_t abIpNetworkSegment[2]; /* upper two bytes of IP segment */
  uint8_t bDefGatewayNode;

  uint8_t bReserved;
  uint32_t aulReserved[5];
} __HIL_PACKED_POST CCLIES_IF_SET_CONFIG_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_CONFIG_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SET_CONFIG_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_SET_CONFIG_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_CONFIG_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_SET_CONFIG_CNF_T;


/* packet union */
typedef union CCLIES_IF_SET_CONFIG_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SET_CONFIG_REQ_T tReq;
  CCLIES_IF_SET_CONFIG_CNF_T tCnf;
} CCLIES_IF_SET_CONFIG_PCK_T;

/******************************************************************************
 * Packet: CCLIES_IF_CMD_STATUS_IND/CCLIES_IF_CMD_STATUS_RES
 */

#define VAL_CCLIES_IF_STATUS_IND_LED_STATUS_OFF 0
#define VAL_CCLIES_IF_STATUS_IND_LED_STATUS_ON 1
#define VAL_CCLIES_IF_STATUS_IND_LED_STATUS_BLINKING 2

/* indication packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_IND_DATA_LED_Ttag
{
  uint8_t bRunLed;
  uint8_t bErrorLed;
  uint8_t bDlinkLed;
  uint8_t bLErr1Led;
  uint8_t bLErr2Led;
  uint8_t bSdLed;
  uint8_t bRdLed;
} __HIL_PACKED_POST CCLIES_IF_STATUS_IND_DATA_LED_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_IND_DATA_MASTER_Ttag
{
  uint8_t bRunCondition;
  uint8_t bErrorCondition;
  uint8_t fLostMaster;
  uint16_t usCyclicStatus;
  uint8_t fMasterAppRun;
  uint8_t fMasterAppErr;
} __HIL_PACKED_POST CCLIES_IF_STATUS_IND_DATA_MASTER_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_IND_DATA_PROCESSDATA_Ttag
{
  uint16_t usCurrentRWwPoints;
  uint16_t usCurrentRYBytes;
  uint16_t usCurrentRWrPoints;
  uint16_t usCurrentRXBytes;
} __HIL_PACKED_POST CCLIES_IF_STATUS_IND_DATA_PROCESSDATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_IND_DATA_Ttag
{
  CCLIES_IF_STATUS_IND_DATA_LED_T tLedStatus;
  CCLIES_IF_STATUS_IND_DATA_MASTER_T tMasterStatus;
  CCLIES_IF_STATUS_IND_DATA_PROCESSDATA_T tProcessData;
} __HIL_PACKED_POST CCLIES_IF_STATUS_IND_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_STATUS_IND_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_STATUS_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_STATUS_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_STATUS_RES_T;


/* packet union */
typedef union CCLIES_IF_STATUS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_STATUS_IND_T tInd;
  CCLIES_IF_STATUS_RES_T tRes;
} CCLIES_IF_STATUS_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_GET_STATUS_REQ/CCLIES_IF_CMD_GET_STATUS_REQ
 */

#define VAL_CCLIES_IF_GET_STATUS_CNF_LED_STATUS_OFF 0
#define VAL_CCLIES_IF_GET_STATUS_CNF_LED_STATUS_ON 1
#define VAL_CCLIES_IF_GET_STATUS_CNF_LED_STATUS_BLINKING 2

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_CNF_DATA_LED_Ttag
{
  uint8_t bRunLed;
  uint8_t bErrorLed;
  uint8_t bDlinkLed;
  uint8_t bLErr1Led;
  uint8_t bLErr2Led;
  uint8_t bSdLed;
  uint8_t bRdLed;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_CNF_DATA_LED_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_CNF_DATA_MASTER_Ttag
{
  uint8_t bRunCondition;
  uint8_t bErrorCondition;
  uint8_t fLostMaster;
  uint16_t usCyclicStatus;
  uint8_t fMasterAppRun;
  uint8_t fMasterAppErr;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_CNF_DATA_MASTER_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_CNF_DATA_PROCESSDATA_Ttag
{
  uint16_t usCurrentRWwPoints;
  uint16_t usCurrentRYBytes;
  uint16_t usCurrentRWrPoints;
  uint16_t usCurrentRXBytes;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_CNF_DATA_PROCESSDATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_CNF_DATA_Ttag
{
  CCLIES_IF_GET_STATUS_CNF_DATA_LED_T tLedStatus;
  CCLIES_IF_GET_STATUS_CNF_DATA_MASTER_T tMasterStatus;
  CCLIES_IF_GET_STATUS_CNF_DATA_PROCESSDATA_T tProcessData;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_STATUS_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_GET_STATUS_CNF_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_GET_STATUS_CNF_T;


/* packet union */
typedef union CCLIES_IF_GET_STATUS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_GET_STATUS_REQ_T tReq;
  CCLIES_IF_GET_STATUS_CNF_T tCnf;
} CCLIES_IF_GET_STATUS_PCK_T;

/******************************************************************************
 * Packet: CCLIES_IF_CMD_SET_DET_NODE_STATUS_REQ/CCLIES_IF_CMD_SET_DET_NODE_STATUS_CNF
 */

/* bDetailedRunStatus */
#define CCLIES_IF_SET_DET_NODE_STATUS_NONE 0
#define CCLIES_IF_SET_DET_NODE_STATUS_STOP_OR_PAUSE 1
#define CCLIES_IF_SET_DET_NODE_STATUS_RUN_OR_STEP 2

/* bDetailedErrorStatus */
#define CCLIES_IF_SET_DET_NODE_ERROR_NONE 0
#define CCLIES_IF_SET_DET_NODE_ERROR_LIGHT 1
#define CCLIES_IF_SET_DET_NODE_ERROR_MEDIUM 2
#define CCLIES_IF_SET_DET_NODE_ERROR_CRITICAL 3

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_DET_NODE_STATUS_REQ_DATA_Ttag
{
  uint8_t bDetailedRunStatus;
  uint8_t bDetailedErrorStatus;
} __HIL_PACKED_POST CCLIES_IF_SET_DET_NODE_STATUS_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_DET_NODE_STATUS_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SET_DET_NODE_STATUS_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_SET_DET_NODE_STATUS_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SET_DET_NODE_STATUS_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_SET_DET_NODE_STATUS_CNF_T;


/* packet union */
typedef union CCLIES_IF_SET_DET_NODE_STATUS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SET_DET_NODE_STATUS_REQ_T tReq;
  CCLIES_IF_SET_DET_NODE_STATUS_CNF_T tCnf;
} CCLIES_IF_SET_DET_NODE_STATUS_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_REGISTER_TRANSIENT1_REQ/CCLIES_IF_CMD_REGISTER_TRANSIENT1_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT1_REQ_DATA_Ttag
{
  uint8_t bDatatype;
  uint16_t usDataSubtype;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT1_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT1_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT1_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT1_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT1_CNF_DATA_Ttag
{
  uint8_t bDatatype;
  uint16_t usDataSubtype;
  uint32_t ulTransient1Handle;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT1_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT1_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT1_CNF_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT1_CNF_T;


/* packet union */
typedef union CCLIES_IF_REGISTER_TRANSIENT1_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT1_REQ_T tReq;
  CCLIES_IF_REGISTER_TRANSIENT1_CNF_T tCnf;
} CCLIES_IF_REGISTER_TRANSIENT1_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_UNREGISTER_TRANSIENT1_REQ/CCLIES_IF_CMD_UNREGISTER_TRANSIENT1_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_DATA_Ttag
{
  uint32_t ulTransient1Handle;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT1_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT1_CNF_T;


/* packet union */
typedef union CCLIES_IF_UNREGISTER_TRANSIENT1_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_TRANSIENT1_REQ_T tReq;
  CCLIES_IF_UNREGISTER_TRANSIENT1_CNF_T tCnf;
} CCLIES_IF_UNREGISTER_TRANSIENT1_PCK_T;


/******************************************************************************
 * Transient1 data
 */

typedef __HIL_PACKED_PRE struct CCLIES_IF_TRANSIENT1_DATA_Ttag
{
  uint16_t usNetworkID;
  uint16_t usNodeID;
  uint8_t bDataClassification;
  uint16_t usDataSubClassification;
  uint16_t usTransientDataAllSize;
  uint8_t abData[1024];
} __HIL_PACKED_POST CCLIES_IF_TRANSIENT1_DATA_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_SEND_TRANSIENT1_REQ/CCLIES_IF_CMD_SEND_TRANSIENT1_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_TRANSIENT1_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_TRANSIENT1_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_SEND_TRANSIENT1_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_TRANSIENT1_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_SEND_TRANSIENT1_CNF_T;


/* packet union */
typedef union CCLIES_IF_SEND_TRANSIENT1_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SEND_TRANSIENT1_REQ_T tReq;
  CCLIES_IF_SEND_TRANSIENT1_CNF_T tCnf;
} CCLIES_IF_SEND_TRANSIENT1_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_RECV_TRANSIENT1_IND/CCLIES_IF_CMD_RECV_TRANSIENT1_RES
 */

/* indication packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_TRANSIENT1_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_TRANSIENT1_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_RECV_TRANSIENT1_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_TRANSIENT1_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_RECV_TRANSIENT1_RES_T;


/* packet union */
typedef union CCLIES_IF_RECV_TRANSIENT1_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_RECV_TRANSIENT1_IND_T tInd;
  CCLIES_IF_RECV_TRANSIENT1_RES_T tRes;
} CCLIES_IF_RECV_TRANSIENT1_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_REGISTER_TRANSIENT2_REQ/CCLIES_IF_CMD_REGISTER_TRANSIENT2_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT2_REQ_DATA_Ttag
{
  uint8_t bDataClassification;
  uint8_t bCommandType;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT2_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT2_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT2_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT2_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT2_CNF_DATA_Ttag
{
  uint8_t bDataClassification;
  uint8_t bCommandType;
  uint32_t ulTransient2Handle;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT2_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_TRANSIENT2_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT2_CNF_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_TRANSIENT2_CNF_T;


/* packet union */
typedef union CCLIES_IF_REGISTER_TRANSIENT2_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_TRANSIENT2_REQ_T tReq;
  CCLIES_IF_REGISTER_TRANSIENT2_CNF_T tCnf;
} CCLIES_IF_REGISTER_TRANSIENT2_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_UNREGISTER_TRANSIENT2_REQ/CCLIES_IF_CMD_UNREGISTER_TRANSIENT2_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_DATA_Ttag
{
  uint32_t ulTransient2Handle;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_TRANSIENT2_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_TRANSIENT2_CNF_T;


/* packet union */
typedef union CCLIES_IF_UNREGISTER_TRANSIENT2_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_TRANSIENT2_REQ_T tReq;
  CCLIES_IF_UNREGISTER_TRANSIENT2_CNF_T tCnf;
} CCLIES_IF_UNREGISTER_TRANSIENT2_PCK_T;


/******************************************************************************
 * Transient2 data
 */

typedef __HIL_PACKED_PRE struct CCLIES_IF_TRANSIENT2_DATA_HEAD_Ttag
{
  uint16_t usL;
  uint8_t bRsv;
  uint8_t bTP_SF;
  uint8_t bFNO;
  uint8_t bDT;
  uint8_t bDA;
  uint8_t bSA;
  uint8_t bDAT;
  uint8_t bSAT;
  uint8_t bDMF;
  uint8_t bSMF;
  uint8_t bDNA;
  uint8_t bDS;
  uint16_t usDID;
  uint8_t bSNA;
  uint8_t bSS;
  uint16_t usSID;
  uint16_t usL1;
  uint8_t bCT;
  uint8_t bRsv2;
  uint16_t usAPS;
} __HIL_PACKED_POST CCLIES_IF_TRANSIENT2_DATA_HEAD_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_TRANSIENT2_DATA_Ttag
{
  uint8_t bDataClassification;
  CCLIES_IF_TRANSIENT2_DATA_HEAD_T tCclHead;
  uint8_t abData[960];
} __HIL_PACKED_POST CCLIES_IF_TRANSIENT2_DATA_T;

/******************************************************************************
 * Packet: CCLIES_IF_CMD_SEND_TRANSIENT2_REQ/CCLIES_IF_CMD_SEND_TRANSIENT2_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_TRANSIENT2_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_TRANSIENT2_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_SEND_TRANSIENT2_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_TRANSIENT2_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_SEND_TRANSIENT2_CNF_T;


/* packet union */
typedef union CCLIES_IF_SEND_TRANSIENT2_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SEND_TRANSIENT2_REQ_T tReq;
  CCLIES_IF_SEND_TRANSIENT2_CNF_T tCnf;
} CCLIES_IF_SEND_TRANSIENT2_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_RECV_TRANSIENT2_IND/CCLIES_IF_CMD_RECV_TRANSIENT2_RES
 */

/* indication packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_TRANSIENT2_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_TRANSIENT2_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_RECV_TRANSIENT2_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_TRANSIENT2_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_RECV_TRANSIENT2_RES_T;


/* packet union */
typedef union CCLIES_IF_RECV_TRANSIENT2_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_RECV_TRANSIENT2_IND_T tInd;
  CCLIES_IF_RECV_TRANSIENT2_RES_T tRes;
} CCLIES_IF_RECV_TRANSIENT2_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_REGISTER_SLMP_REQ/CCLIES_IF_CMD_REGISTER_SLMP_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_SLMP_REQ_DATA_Ttag
{
  uint16_t usCommand;
  uint16_t usSubCommand;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_SLMP_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_REGISTER_SLMP_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_SLMP_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_REGISTER_SLMP_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_SLMP_CNF_DATA_Ttag
{
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint32_t ulSlmpHandle;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_SLMP_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_REGISTER_SLMP_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_REGISTER_SLMP_CNF_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_REGISTER_SLMP_CNF_T;


/* packet union */
typedef union CCLIES_IF_REGISTER_SLMP_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_REGISTER_SLMP_REQ_T tReq;
  CCLIES_IF_REGISTER_SLMP_CNF_T tCnf;
} CCLIES_IF_REGISTER_SLMP_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_UNREGISTER_SLMP_REQ/CCLIES_IF_CMD_UNREGISTER_SLMP_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_SLMP_REQ_DATA_Ttag
{
  uint32_t ulSlmpHandle;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_SLMP_REQ_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_SLMP_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_SLMP_REQ_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_SLMP_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_UNREGISTER_SLMP_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_UNREGISTER_SLMP_CNF_T;


/* packet union */
typedef union CCLIES_IF_UNREGISTER_SLMP_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_UNREGISTER_SLMP_REQ_T tReq;
  CCLIES_IF_UNREGISTER_SLMP_CNF_T tCnf;
} CCLIES_IF_UNREGISTER_SLMP_PCK_T;


/******************************************************************************/
typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_CCL_TRANSIENT_Ttag
{
  uint8_t bDestAddr;
  uint8_t bSrcAddr;
  uint8_t bDestAppType;
  uint8_t bSrcAppType;
  uint8_t bDestModuleFlag;
  uint8_t bSrcModuleFlag;
  uint16_t usDestID;
  uint16_t usSourceID;
  uint8_t bDataNo;
  uint16_t usAppSeqNo;
} __HIL_PACKED_POST CCLIES_IF_SLMP_CCL_TRANSIENT_T;

/* indication packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_HEADER_Ttag
{
  uint16_t usFrameType;
  uint16_t usSerialNumber;
  uint16_t usReserved;
  uint8_t bNetworkNumber;
  uint8_t bStationNumber;
  uint16_t usModuleIONumber;
  uint8_t bRequestingStationNumber;
  uint16_t usLength;
} __HIL_PACKED_POST CCLIES_IF_SLMP_HEADER_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_REQUEST_Ttag
{
  CCLIES_IF_SLMP_CCL_TRANSIENT_T tCclTransientInfo;
  CCLIES_IF_SLMP_HEADER_T tSlmpHead;
  uint16_t usTimer;
  uint16_t usCommand;
  uint16_t usSubCommand;
  uint8_t abData[1024];
} __HIL_PACKED_POST CCLIES_IF_SLMP_REQUEST_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_RESPONSE_Ttag
{
  CCLIES_IF_SLMP_CCL_TRANSIENT_T tCclTransientInfo;
  CCLIES_IF_SLMP_HEADER_T tSlmpHead;
  uint16_t usEndCode;
  uint8_t abData[1024];
} __HIL_PACKED_POST CCLIES_IF_SLMP_RESPONSE_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_ERROR_RESPONSE_Ttag
{
  CCLIES_IF_SLMP_CCL_TRANSIENT_T tCclTransientInfo;
  CCLIES_IF_SLMP_HEADER_T tSlmpHead;
  uint16_t usEndCode;
  __HIL_PACKED_PRE struct
  {
    uint8_t bNetworkNo;
    uint8_t bStationNo;
    uint16_t usRespUtIONo;       /**< Destination unit I/O number */
    uint8_t bRequStNo;        /**< Destination multi-drop number */
    uint16_t usCmd;
    uint16_t usSubCmd;
  } __HIL_PACKED_POST tError;
} __HIL_PACKED_POST CCLIES_IF_SLMP_ERROR_RESPONSE_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_SLMP_CCL_HEAD_Ttag
{
  CCLIES_IF_SLMP_CCL_TRANSIENT_T tCclTransientInfo;
  CCLIES_IF_SLMP_HEADER_T tSlmpHead;
} __HIL_PACKED_POST CCLIES_IF_SLMP_CCL_HEAD_T;

typedef __HIL_PACKED_PRE union CCLIES_IF_SLMP_DATA_Ttag
{
  CCLIES_IF_SLMP_CCL_HEAD_T tHead;
  CCLIES_IF_SLMP_REQUEST_T tReq;
  CCLIES_IF_SLMP_RESPONSE_T tRes;
  CCLIES_IF_SLMP_ERROR_RESPONSE_T tErrorRes;
} __HIL_PACKED_POST CCLIES_IF_SLMP_DATA_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_SEND_SLMP_REQ/CCLIES_IF_CMD_SEND_SLMP_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_SLMP_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SLMP_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_SEND_SLMP_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_SEND_SLMP_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_SEND_SLMP_CNF_T;


/* packet union */
typedef union CCLIES_IF_SEND_SLMP_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SEND_SLMP_REQ_T tReq;
  CCLIES_IF_SEND_SLMP_CNF_T tCnf;
} CCLIES_IF_SEND_SLMP_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_RECV_SLMP_IND/CCLIES_IF_CMD_RECV_SLMP_RES
 */

/* indication packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_SLMP_IND_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_SLMP_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_RECV_SLMP_IND_T;


/* response packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_RECV_SLMP_RES_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_RECV_SLMP_RES_T;


/* packet union */
typedef union CCLIES_IF_RECV_SLMP_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_RECV_SLMP_IND_T tInd;
  CCLIES_IF_RECV_SLMP_RES_T tRes;
} CCLIES_IF_RECV_SLMP_PCK_T;


/******************************************************************************
 * Packet: CCLIES_IF_CMD_GET_COUNTERS_REQ/CCLIES_IF_CMD_GET_COUNTERS_CNF
 */

/* request packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_COUNTERS_REQ_Ttag
{
  HIL_PACKET_HEADER_T tHead;
} __HIL_PACKED_POST CCLIES_IF_GET_COUNTERS_REQ_T;


/* confirmation packet */
typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_COUNTERS_CNF_DATA_Ttag
{
  uint32_t ulPort1HecErrorCounter;
  uint32_t ulPort1DcsFcsErrorCounter;
  uint32_t ulPort1UnderSizeErrorCounter;
  uint32_t ulPort1ForwardFrameCounter;
  uint32_t ulPort1UpwardFrameCounter;
  uint32_t ulPort1ForwardOverflowErrorCounter;
  uint32_t ulPort1UpwardOverflowErrorCounter;
  uint32_t ulPort2HecErrorCounter;
  uint32_t ulPort2DcsFcsErrorCounter;
  uint32_t ulPort2UnderSizeErrorCounter;
  uint32_t ulPort2ForwardFrameCounter;
  uint32_t ulPort2UpwardFrameCounter;
  uint32_t ulPort2ForwardOverflowErrorCounter;
  uint32_t ulPort2UpwardOverflowErrorCounter;
} __HIL_PACKED_POST CCLIES_IF_GET_COUNTERS_CNF_DATA_T;

typedef __HIL_PACKED_PRE struct CCLIES_IF_GET_COUNTERS_CNF_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_GET_COUNTERS_CNF_DATA_T tData;
} __HIL_PACKED_POST CCLIES_IF_GET_COUNTERS_CNF_T;


/* packet union */
typedef union CCLIES_IF_GET_COUNTERS_PCK_Ttag
{
  HIL_PACKET_HEADER_T tHead;
  CCLIES_IF_GET_COUNTERS_REQ_T tReq;
  CCLIES_IF_GET_COUNTERS_CNF_T tCnf;
} CCLIES_IF_GET_COUNTERS_PCK_T;


/******************************************************************************/
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(CCLIESIF_PUBLIC_H)
#endif

#endif
